/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/


class MyDialog : public Dialog
{
public:
	MyDialog() : Dialog(IDD_MYDIALOG, "testlbcopy")
	{
	}

	virtual int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		//Launch the modeless dialog
		int nRet = Dialog::Create(hParent);
		Visible=true;
		return nRet;
	}

protected:
///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_OK(OnOK)
		ON_CANCEL(OnCancel)
		ON_BN_CLICKED(IDC_BTN_COPYALL, OnClickCopyAll)
		ON_BN_CLICKED(IDC_BTN_COPYSEL, OnClickCopySel)
		ON_BN_CLICKED(IDC_BTN_MOVEALL, OnClickMoveAll)
		ON_BN_CLICKED(IDC_BTN_MOVESEL, OnClickMoveSel)
	EVENTS_END
///----------------------------------------------
	
	BOOL OnInitDialog()
	{
		m_list1 = GetItem(IDC_LIST1);
		string str;
		for( int i = 0; i < 10; i++ )
		{
			str.Format("item %d", i);
			m_list1.AddString(str);
		}
		
		m_list2 = GetItem(IDC_LIST2);
		
		m_btnCopyAll = GetItem(IDC_BTN_COPYALL);
		m_btnCopySel = GetItem(IDC_BTN_COPYSEL);
		m_btnMoveAll = GetItem(IDC_BTN_MOVEALL);
		m_btnMoveSel = GetItem(IDC_BTN_MOVESEL);

		return TRUE;
	}

	BOOL OnDestroy(void)
	{
		return TRUE;
	}

	BOOL OnOK()
	{
		return TRUE;
	}
	
	BOOL OnCancel()
	{
		return TRUE;
	}

	BOOL OnClickCopyAll(Control ctrl)
	{
		m_list2.CopyAll(m_list1, TRUE, 0);
		return TRUE;
	}

	BOOL OnClickCopySel(Control ctrl)
	{
		m_list2.CopySel(m_list1, FALSE, 0);
		return TRUE;
	}

	BOOL OnClickMoveAll(Control ctrl)
	{
		m_list2.MoveAll(m_list1, TRUE, 0);
		return TRUE;
	}

	BOOL OnClickMoveSel(Control ctrl)
	{
		m_list2.MoveSel(m_list1, FALSE, 0);
		return TRUE;
	}


private:
	Button m_btnCopyAll;
	Button m_btnCopySel;
	Button m_btnMoveAll;
	Button m_btnMoveSel;

	ListBox m_list1;
	ListBox m_list2;
};
